var options = {};
const DEFAULT_PROMPT_TEMPLATE = `Opposite of this: Create an opposite of this text: {text}?
What is this: What is this {text}?
Create a Jokes from this: Create a jokes from this: {text}
Explain this: Explain this text so I can understand: {text}
Synonym of this: What is the synonym of {text}?
Create a Summary: Summarized this text: {text}`;
const DEFAULT_PROMPT_PAGE = 'Greet your listeners and provide them a summary of the following news: {page}';
const DEFAULT_SYSTEM_PROMPT = "You are a professional radio announcer. Your name is Aria and your radio station is Genzi FM. You will speak in English only. Today is {day} and current date time is {date} {time}";
const DEFAULT_INVALID_TOKEN = "We're sorry to inform you that the token provided seems to be invalid. In order to ensure a seamless experience with our service tailored just for you, kindly enter a valid token within the BudGPT options page. We're here to assist you every step of the way in making the most of our service.";
const DEFAULT_CHATGPT_NOT_OPEN = "Please ensure you have chat GPT website opened in a tab.";
const DEFAULT_VOICE_NAME = "Microsoft Server Speech Text to Speech Voice (en-US, AriaNeural)";
const DEFAULT_SPEAK_ENABLE = "yes";
const DEFAULT_REWRITE_ENABLE = "yes";
const URL_VALIDATE_TOKEN = "https://us-central1-automaticfakechatgenerator.cloudfunctions.net/app/validatetokenjs?";
var prompts = [];
var tokenValid = false;
var lastCheckTimestamp = null;

class CspManager {
	constructor() {

	}

	disable(id) {
		try {
			let addRules = [];
			let removeRuleIds = [];

			addRules.push({
				id,
				action: {
					type: 'modifyHeaders',
					responseHeaders: [{ header: 'Content-Security-Policy', operation: 'set', value: '' }]
				},
				condition: { urlFilter: "|https*", resourceTypes: ['main_frame', 'sub_frame'] }
			})

			chrome.browsingData.remove({}, { serviceWorkers: true }, () => { })
			chrome.declarativeNetRequest.updateSessionRules({ addRules, removeRuleIds });
		} catch (e) {

		}		
	}
}

class TokenManager {
	constructor() {
		this.clientId = '';
		this.token = '';
		this.tokenValid = false;
	}

	getTokenValid() {
		return this.tokenValid;
	}

	update(options) {
		this.clientId = options.clientId;
		this.token = options.token;
		this.validateToken();
	}

	validateToken(callback) {
		console.log("validate token")
		var _this = this;
		fetch(
			URL_VALIDATE_TOKEN + "token=" + this.token + "&clientid=" + this.clientId + "&source=budgpt"
		).then(
			(response) => response.text()
		).then(
			function (data) {
				console.log("token", data);
				var obj = JSON.parse(data);
				if (obj.result == "1") {
					_this.tokenValid = true;
				} else {
					_this.tokenValid = false;
				}

				if (callback != null) {
					callback(_this.tokenValid);
				}
			}
		);
	}
}

class ContextMenu {
	constructor() {
		this.tokenManager = null;
		this.prompts = [];
		this.chatGPT = null;
		this.configManager = null;
	}

	setConfigManager(configManager) {
		this.configManager = configManager;
	}

	setChatGPT(chatGPT) {
		this.chatGPT = chatGPT;
	}

	setTokenManager(tokenManager) {
		this.tokenManager = tokenManager;
	}

	listen() {
		var _this = this;
		chrome.contextMenus.onClicked.addListener((info, tab) => {
			if (_this.tokenManager.getTokenValid()) {
				_this.execute(info, tab);
			} else {
				_this.invalidToken(info, tab);
			}
		});
	}

	invalidToken(info, tab) {
		chrome.tabs.sendMessage(tab.id, {
			prompt: DEFAULT_INVALID_TOKEN,
			command: "ShowMessage"
		});
	}

	execute(info, tab) {
		var _this = this;
		if (info.menuItemId.startsWith("budgptsub")) {
			var promptIndex = info.menuItemId.split("-")[1];
			var prompt = this.prompts[promptIndex];

			if (prompt.indexOf("{text}") != -1) {
				prompt = prompt.replaceAll("{text}", info.selectionText);
			}

			if (prompt.indexOf("{page}") != -1) {
				var message = {};
				message.command = "GetBody";
				chrome.tabs.sendMessage(tab.id, message, function (data) {
					prompt = prompt.replaceAll("{page}", data.body);
					var chatGPT = new ChatGPT();
					chatGPT.setConfigManager(_this.configManager);
					chatGPT.setTab(tab);
					chatGPT.setAccessToken(_this.chatGPT.accessToken);
					chatGPT.submitPrompt(prompt);
				});
			} else {
				var chatGPT = new ChatGPT();
				chatGPT.setConfigManager(_this.configManager);
				chatGPT.setTab(tab);
				chatGPT.setAccessToken(_this.chatGPT.accessToken);
				chatGPT.submitPrompt(prompt);
			}
		}
	}

	update(options) {
		var _this = this;
		chrome.contextMenus.removeAll(function () {
			chrome.contextMenus.create({
				id: 'budgpt-parent',
				title: 'Send to ChatGPT',
				contexts: ['selection', 'page']
			});
			_this.prompts = [];
			var templates = options.promptTemplate.split("\n");
			for (var i = 0; i < templates.length; i++) {
				var line = templates[i].split(":");
				var menuName = line.shift().trim();
				var prompt = line.join(": ");
				_this.prompts.push(prompt);
				var contexts = 'selection';
				if (prompt.indexOf("{page}") != -1) {
					contexts = 'page';
				}
				chrome.contextMenus.create({
					id: 'budgptsub-' + i,
					title: menuName,
					parentId: "budgpt-parent",
					contexts: [contexts]
				});
			}
		});
	}
}

class ConfigManager {
	constructor() {
		this.options = {};
		this.listeners = new Array();
	}

	addListener(listener) {
		this.listeners.push(listener);
	}

	getOptions() {
		return this.options;
	}

	notifyListeners() {
		for (var i = 0; i < this.listeners.length; i++) {
			try {
				this.listeners[i].update(this.options);
			} catch (e) {
				//console.loge.log("Exception happened during config update");
				//console.loge.log(e);
			}
		}
	}

	listen(callback) {
		var _this = this;
		chrome.storage.sync.onChanged.addListener(function (changes, namespace) {
			_this.updateConfig();
		});
		_this.updateConfig(callback);
	}

	updateConfig(callback) {
		var _this = this;
		chrome.storage.sync.get({
			promptTemplate: DEFAULT_PROMPT_TEMPLATE,
			voiceName: DEFAULT_VOICE_NAME,
			enableSpeak: DEFAULT_SPEAK_ENABLE,
			enableRewrite: DEFAULT_REWRITE_ENABLE,
			promptPage: DEFAULT_PROMPT_PAGE,
			systemPrompt: DEFAULT_SYSTEM_PROMPT,
			token: '',
			clientId: ''
		}, function (items) {
			_this.options = items;
			_this.notifyListeners();
			if (callback != null) {
				callback();
			}
		});
	}
}

class ChatGPT {
	constructor() {
		this.accessToken = null;
		this.tab = null;
		this.parentMessageId = this.generateRandomUUID();
		this.configManager = null;
	}

	setConfigManager(configManager) {
		this.configManager = configManager;
	}

	setAccessToken(accessToken) {
		this.accessToken = accessToken;
	}

	setTab(tab) {
		this.tab = tab;
	}

	fetchSession(callback) {
		var _this = this;
		fetch("https://chat.openai.com/api/auth/session", {
			"headers": {
				"accept": "*/*",
				"accept-language": "en-US,en;q=0.9",
				"cache-control": "no-cache",
				"pragma": "no-cache",
				"sec-ch-ua": "\"Google Chrome\";v=\"117\", \"Not;A=Brand\";v=\"8\", \"Chromium\";v=\"117\"",
				"sec-ch-ua-mobile": "?0",
				"sec-ch-ua-platform": "\"Windows\"",
				"sec-fetch-dest": "empty",
				"sec-fetch-mode": "cors",
				"sec-fetch-site": "same-origin",
				"Referer": "https://chat.openai.com/",
				"Referrer-Policy": "same-origin"
			},
			"body": null,
			"method": "GET"
		})
			.then((response) => { return response.json(); })
			.then((json) => {
				_this.accessToken = json.accessToken;
				if (callback != null) {
					callback(json);
				}
			});
	}

	handleServerSentEvents(event) {
		chrome.tabs.sendMessage(this.tab.id, {
			command: 'ReceiveEvent',
			event: event
		});
		console.log(event);
	}

	generateRandomUUID() {
		var b = {
			randomUUID: "undefined" != typeof crypto && crypto.randomUUID && crypto.randomUUID.bind(crypto)
		};

		return b.randomUUID();
	}

	getCurrentDate() {
		const currentDate = new Date();
		const year = currentDate.getFullYear();
		const month = (currentDate.getMonth() + 1).toString().padStart(2, '0');
		const day = currentDate.getDate().toString().padStart(2, '0');
		const formattedDate = `${year}-${month}-${day}`;
		return formattedDate;
	}

	getCurrentTime() {
		const currentDate = new Date();
		const hours = currentDate.getHours().toString().padStart(2, '0');
		const minutes = currentDate.getMinutes().toString().padStart(2, '0');
		const seconds = currentDate.getSeconds().toString().padStart(2, '0');
		const formattedTime = `${hours}:${minutes}:${seconds}`;
		return formattedTime;
	}

	getCurrentDayName() {
		var daysOfWeek = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
		var today = new Date();
		var dayIndex = today.getDay();
		var dayName = daysOfWeek[dayIndex];
		return dayName;
	}

	getSystemPrompt() {
		var _this = this;
		var systemPrompt = _this.configManager.getOptions().systemPrompt;
		if (systemPrompt != null && systemPrompt.length > 0) {
			return {
				"id": _this.generateRandomUUID(),
				"role": "system",
				"content": {
					"content_type": "text",
					"parts": [
						systemPrompt
							.replaceAll("{date}", _this.getCurrentDate())
							.replaceAll("{time}", _this.getCurrentTime())
							.replaceAll("{day}", _this.getCurrentDayName())
					]
				}
			};
		} else {
			return null;
		}
	}

	getBDA(callback){
		var requestOptions = {
			method: 'GET',
			redirect: 'follow'
		  };
		  
		  fetch("https://bda.aigpt-summary.com/api/bda", requestOptions)
			.then(response => response.text())
			.then(result => callback(result));

			
	}

	getArkoseToken(bda, callback) {
		//console.log(bda);
		fetch("https://tcr9i.chat.openai.com/fc/gt2/public_key/35536E1E-65B4-4D96-9D97-6ADB7EFF8147", {
			"headers": {
			  "accept": "*/*",
			  "accept-language": "en-US,en;q=0.9",
			  "cache-control": "no-cache",
			  "content-type": "application/x-www-form-urlencoded; charset=UTF-8",
			  "pragma": "no-cache",
			  "sec-fetch-dest": "empty",
			  "sec-fetch-mode": "cors",
			  "sec-fetch-site": "same-origin"
			},
			"referrer": "https://tcr9i.chat.openai.com/v2/1.5.5/enforcement.fbfc14b0d793c6ef8359e0e4b4a91f67.html",
			"referrerPolicy": "strict-origin-when-cross-origin",
			"body": bda,
			"method": "POST",
			"mode": "cors",
			"credentials": "include"
		  }).then((data) => {return data.json();}).then((json) => {callback(json.token.trim());});
	}

	submitPrompt(prompt) {
		var _this = this;
		_this.submitPromptInternal(prompt, null);	
	}

	submitPromptInternal(prompt, arkoseToken) {
		console.log("start submit");
		var _this = this;
		var systemPrompt = _this.getSystemPrompt();
		var messages = [{
			"id": _this.generateRandomUUID(),
			"role": "user",
			"content": {
				"content_type": "text",
				"parts": [
					prompt.trim()
				]
			}
		}];

		if (systemPrompt != null) {
			messages.push(systemPrompt);
		}
		
		var body = {
			"action": "next",
			"messages": messages,
			"parent_message_id": _this.parentMessageId,
			"model": "text-davinci-002-render",
			"arkose_token": arkoseToken,
			"history_and_training_disabled": true,
			"conversation_mode":{"kind":"primary_assistant"},
			"timezone_offset_min":-420,"suggestions":[],
			"force_paragen":false,"force_rate_limit":false

		};
		console.log("start fetch start");

		fetch("https://chat.openai.com/backend-api/conversation", {
			"headers": {
				"accept": "*/*",
				"accept-language": "en-US",
				"authorization": "Bearer " + this.accessToken,
				"cache-control": "no-cache",
				"content-type": "application/json",
				"pragma": "no-cache",
				"sec-fetch-dest": "empty",
				"sec-fetch-mode": "cors",
				"sec-fetch-site": "same-origin"
			},
			"referrer": "https://chat.openai.com/?model=text-davinci-002-render",
			"referrerPolicy": "same-origin",
			"body": JSON.stringify(body),
			"method": "POST",
			"mode": "cors",
			"credentials": "include"
		}).then((response) => {
			console.log("start fetch done");
			if (!response.ok) {
				throw new Error(`HTTP error! Status: ${response.status}`);
			}
			// Ensure the response is of type text/event-stream
			//if (response.headers.get('content-type') !== 'text/event-stream') {
			//throw new Error('Response is not of type text/event-stream');
			//}
			// Create a ReadableStream to parse the server-sent events
			const stream = response.body.getReader();
			let buffer = '';
			return (function read() {
				return stream.read().then(({ done, value }) => {
					if (done) {
						// Stream has ended
						return;
					}
					// Convert the received chunk to text
					const chunk = new TextDecoder('utf-8').decode(value);
					buffer += chunk;
					// Split the buffer into individual events and process them
					const parts = buffer.split('\n\n');
					buffer = parts.pop();
					parts.forEach((part) => {
						const event = new Event('message');
						if (part.indexOf("[DONE]") == -1) {
							event.data = JSON.parse(part.substring(6));
							event.complete = false;
						} else {
							event.data = null;
							event.complete = true;
						}
						_this.handleServerSentEvents(event);
					});
					// Continue reading the stream
					return read();
				});
			})();
		})
			.catch((error) => {
				//console.loge.error('Fetch error:', error);
			});;
	}
}

class BackgroundScript {
	constructor() {
		this.tokenManager = new TokenManager();

		this.contextMenu = new ContextMenu();
		this.contextMenu.setTokenManager(this.tokenManager);

		this.configManager = new ConfigManager();
		this.configManager.addListener(this.contextMenu);
		this.configManager.addListener(this.tokenManager);

		this.contextMenu.setConfigManager(this.configManager);

		this.cspManager = new CspManager();
		this.chatGPT = new ChatGPT();
		this.chatGPT.setConfigManager(this.configManager);
		this.chatGPT.fetchSession();
		this.contextMenu.setChatGPT(this.chatGPT);
	}

	listenMessage() {

		// Listen for messages from content scripts
		var _this = this;
		chrome.runtime.onMessage.addListener(function (request, sender, sendResponse) {
			if (request.message == "DisableCsp") {
				_this.cspManager.disable(sender.tab.id);
				sendResponse({ message: "CSP is now disabled" });
			} else if (request.message == 'PageAction') {
				console.log("page action receive");
				if (_this.tokenManager.getTokenValid()) {
					console.log("token valid");
					var chatGPT = new ChatGPT();
					chatGPT.setConfigManager(_this.configManager);
					chatGPT.setTab(sender.tab);
					chatGPT.setAccessToken(_this.chatGPT.accessToken);
					console.log("setup access token done, will send");
					chatGPT.submitPrompt(request.prompt);
					console.log("sent done");
					sendResponse({ message: "Prompt sent" });
				} else {
					chrome.tabs.sendMessage(sender.tab.id, {
						prompt: DEFAULT_INVALID_TOKEN,
						command: "ShowMessage"
					});
					sendResponse({ message: "Invalid token" });
				}
			} else if (request.message == "ValidateToken") {
				if (_this.tokenManager.getTokenValid() == false) {
					_this.tokenManager.validateToken(function (valid) {
						chrome.tabs.sendMessage(sender.tab.id, {
							valid: valid,
							command: "ValidationResult"
						});						
					});
					sendResponse({ message: "Validation on progress", valid: false});
				} else {
					chrome.tabs.sendMessage(sender.tab.id, {
						valid: true,
						command: "ValidationResult"
					});	
					sendResponse({ message: "Done validate token", valid: true });
				}
			}
		});
	}

	init() {
		console.log("Background init");
		var _this = this;
		console.log("load config");
		this.configManager.listen(function () {
			console.log("loaded config");
			_this.tokenManager.validateToken();
			console.log("token validated");
			_this.contextMenu.listen();
			console.log("context menu listen");
			_this.listenMessage();
			console.log("listen...");
		});
	}
}

const backgroundScript = new BackgroundScript();
backgroundScript.init();