// Hi there! If you are here then you are going too far. But it is OK, just let me know if you are interesting to these code :)


const voiceOptions = new VoiceOptions("None");
var FINGERPRINT = null;

jQuery(document).ready(function () {
	loadFingerPrint(function (fingerprint) {
		setTimeout(function () {
			loadOptions();
		}, NUM_LOAD_OPTIONS_TIMEOUT);
		
		jQuery("#save_button").click(function () {
			saveOptions();
		});
		
		jQuery("#validate_token_button").click(function () {
			validateToken(true);
		});
		
		jQuery("#buy_token_button").click(function () {
			buyToken();
		});
		
		validateToken(false);
	});
});

function getVoice(voiceURI) {
	return voiceURI;
}

function setupOnChangeHandler() {
	jQuery("#default_voice").change(function (data){
		speak(getVoice(jQuery("#default_voice").val()), SAMPLE_TEXT);
	});
}

function setupOptions(id, name, selectedVoice) {
	return voiceOptions.getOptions(id, name, selectedVoice);
}

function setupOptionsSpeak(id, name, selectedValue) {
	var opts = [{value:'yes', label:'Enabled'}, {value:'no', label:'Disabled'}];
	var options = '<select id="'+id+'" name="'+name+'">';
	for (var i=0; i<opts.length; i++) {
		var selected = "";
		if (opts[i].value == selectedValue) {
			selected = " selected";
		}
		options = options + '<option value="'+opts[i].value+'"'+ selected +'>'+opts[i].label+'</option>'
	}
	options = options + '</select>';
	return options;
}

function generateUniqueId() {
	return 'bdgpt' + FINGERPRINT;
}

async function hashString(inputString) {
  const encoder = new TextEncoder();
  const data = encoder.encode(inputString);

  const hashBuffer = await crypto.subtle.digest('SHA-256', data);
  const hashArray = Array.from(new Uint8Array(hashBuffer));
  const hashHex = hashArray.map(byte => byte.toString(16).padStart(2, '0')).join('');

  return hashHex;
}	

function loadFingerPrint(callback) {
	const input = drawFingerPrint("budgpt", "clientid");
	hashString(input).then(hashValue => {
	    FINGERPRINT = hashValue;
		callback(FINGERPRINT);
	}).catch(error => {
	  console.error(error);
	});
}

function drawFingerPrint(text1, text2) {
	var canvas = document.createElement('canvas');

    // Get the 2D rendering context
    var ctx = canvas.getContext("2d");

    // Set a fixed canvas size
    canvas.width = 200;
    canvas.height = 50;

    // Set some text and styles
    ctx.textBaseline = "alphabetic";
    ctx.fillStyle = "#f60";
    ctx.fillRect(125, 1, 62, 20);
    ctx.fillStyle = "#069";
    ctx.fillText(text1, 2, 15);
    ctx.fillStyle = "rgba(102, 204, 0, 0.7)";
    ctx.fillText(text2, 2, 30);

    // Render the canvas
    return canvas.toDataURL("image/png");
}

function loadOptions() {
	chrome.storage.sync.get({
		promptTemplate: DEFAULT_PROMPT_TEMPLATE,
		voiceName: DEFAULT_VOICE_NAME,
		enableSpeak: DEFAULT_SPEAK_ENABLE,
		enableRewrite: DEFAULT_REWRITE_ENABLE,
		promptPage: DEFAULT_PROMPT_PAGE,
		systemPrompt: DEFAULT_SYSTEM_PROMPT,
		token: '',
		clientId: generateUniqueId()
	  }, function(items) {		
		var options = setupOptions('default_voice','default_voice', items.voiceName);
		jQuery("#div_default_voice").html(options);
		
		var options = setupOptionsSpeak('enable_speak','enable_speak', items.enableSpeak);
		jQuery("#div_enable_speak").html(options);	

		var options = setupOptionsSpeak('enable_rewrite','enable_rewrite', items.enableRewrite);
		jQuery("#div_enable_rewrite").html(options);
		
		jQuery("#prompt_page").val(items.promptPage);
		jQuery("#system_prompt").val(items.systemPrompt);
		jQuery("#prompt_template").val(items.promptTemplate);
		jQuery("#div_client_id").html('<span style="word-wrap: break-word;">' + items.clientId + '</span>');
		jQuery("#token").val(items.token);
		
		setupOnChangeHandler();
		
		chrome.storage.sync.set({
			clientId: items.clientId
		 });
	});
	
}

function saveOptions() {
	var items = {
		promptTemplate: jQuery("#prompt_template").val(),
		voiceName: jQuery("#default_voice").val(),
		enableSpeak: jQuery("#enable_speak").val(),
		enableRewrite: jQuery("#enable_rewrite").val(),
		promptPage: jQuery("#prompt_page").val(),
		systemPrompt: jQuery('#system_prompt').val(),
		token: jQuery("#token").val()
	  };
	  
	chrome.storage.sync.set(items, function() {
		alert(MSG_CONFIGURATION_SAVED);
	  });
}

function validateToken(notification) {
	var token = jQuery("#token").val();
	if (token != "") {
		chrome.storage.sync.get({
			clientId: ''
		  }, function(items) {
			if (items.clientId != '') {
				validateTokenInternal(token, items.clientId, notification)
			}
		});
	} else {
		if (notification) {
			alert(MSG_EMPTY_TOKEN);
		}
		jQuery("#token").focus();
	}
}

function validateTokenInternal(token, clientid, notification) {
	fetch(
		URL_VALIDATE_TOKEN + "token=" + token + "&clientid=" + clientid
	).then(
		(response) => response.text()
	).then(
		function (data){
			var obj = JSON.parse(data.replace("callbackToken(", "").replace(");","").replace('result', '"result"').replace('token', '"token"').replaceAll("'", '"'));
			if (obj.result == "1") {
				chrome.storage.sync.set({
					membership: 'true'
				  }, function() {
					if (notification) {
						alert(MSG_TOKEN_VALID);
					}
				  });
			} else {
				chrome.storage.sync.set({
					membership: 'false'
				  }, function() {
					  if (notification) {
						alert(MSG_TOKEN_INVALID);
					  }
				  });
				
			}
		}
	);
}

function buyToken() {
	chrome.storage.sync.get({
		clientId: ''
	  }, function(items) {
		if (items.clientId != '') {
			window.location.href = URL_BUY_TOKEN + 'clientid=' + items.clientId;
		}
	});
	
}